﻿/*
VERSION:		1.1
	
USAGE:
	walk_obj.collision  =  new TileCollision( player_mc, walk_obj, collision );
	
NOTE:
	The collision data should be a 2-dimensional array.
	0 = pass
	1+ = block
	
*/
// Define collision "class"
// use as:		walk_obj.collision = new Collision( player_mc, walk_obj, collision_array );			(an instance of the function)
class TileWalkCollision
{
	// variables
	var player_mc;			// Reference to the player sprite		(to get their current position)
	var walk_obj;				// Reference to the walk system		(to alter its velocities)
	var collision_array;		// reference to the collision data		(to determine collision)
	
	
	
	// Constructor()
	function TileWalkCollision( player_mc, walk_obj, collision_array )
	{
		this.player_mc = player_mc;
		this.walk_obj = walk_obj;
		this.collision_array = collision_array;
	}// CONSTRUCTOR()
	
	
	
	// Main()
	function run()
	{
		// extract velocities
		var xVel = walk_obj.xVel;
		var yVel = walk_obj.yVel;
		
		// get player's current tile
		var xPlayer = Math.floor(player_mc._x / 16);
		var yPlayer = Math.floor(player_mc._y / 16);
		
		// get destination tile
		var xDest = xPlayer + xVel;
		var yDest = yPlayer + yVel;
		
		// store collision value
		var collision = collision_array[xDest][yDest];
		
		// if collision value is not 0
		if( collision != 0 )
		{
			// cancel all velocities
			walk_obj.xVel = 0;
			walk_obj.yVel = 0;
		}// if:  collision is imminent
	}// run()
}// TileWalkCollision class